function loseFocus() {
	document.activeElement.blur();
	FOCUS();
}

function handleFocus() {
	// Add event listener on keydown to detect Esc/Enter in text entry
	document.addEventListener('keydown', (event) => {
		if((event.key == "Enter" && document.activeElement.tagName != "TEXTAREA") || event.key == "Escape")
			document.activeElement.blur();
	}, false);
	
	// return focus to host on exit from textarea
	const tx = document.getElementsByTagName("textarea");
	for (let i = 0; i < tx.length; i++)
		tx[i].addEventListener("focusout", loseFocus, false);

	// return focus to host on exit from text input
	const tx2 = document.querySelectorAll('input[type=text]');
	for (let i = 0; i < tx2.length; i++)
		tx2[i].addEventListener("focusout", loseFocus, false);
}

function show(page){
	var pages = ["Ex1", "Ex2", "Ex3"];
	var buttons = ["Btn1", "Btn2", "Btn3"];
	
	var i;
	for	(i = 0; i < pages.length; i++) {
		var e = document.getElementById(pages[i]);
		if(!e) continue;
			
		e.style.display = i == page ? 'block' : 'none';
	
		if(i == page)
			document.getElementById("title").innerHTML = e.getAttribute("data-title");
		
		var b = document.getElementById(buttons[i]);
		if(b)
			b.className = i == page ? 'page-selected' : 'page';
		
		e.scrollTop = 0;
  }
}

async function tryOnline(path) {
	try {
		const response = await fetch("https://nash.audio/manhattan/pdf/test");
		const blob = await response.blob();
		console.log(blob);
		if(blob){
			console.log("Connected.");
			window.location.replace(path);
		}
	} catch (error) {
		console.log("Not connected.");
	}		
}

function toggle(id) {
  var x = document.getElementById(id);
  if (x.style.display === "none") {
    x.style.display = "block";
  } else {
    x.style.display = "none";
  }
}

function toolbar(buttons){
	var tb = document.getElementById("toolbar");
	
	var html = "<table width=100% class='navbar'><tr>";
  html += "<td id='title' class='title'></td>";
	
	for(b=0; b<buttons; b++)
		html += "<td id='Btn" + (b+1) + "'><a class='navbar' href='#top' onClick='show(" + b + ");'>" + (b+1) + "</a></td>";
  
	html += "<td class='maximise'><a class='maximise' href='#top' target='_new'>&boxbox;</a></td><td class='close'><a class='navbar' href='#top' onClick='SEND(\"HELP 0\");'>&#x2573;</a></td></tr></table>";
	
	tb.innerHTML = html;
}

function scorehint(text){
    document.getElementById("scoretext").style.height = "13pt";
    document.getElementById("scoretext").innerHTML = text;
}

function runCode(text){
    CODE(text);
}

function SEND(message){
	if(navigator.platform.indexOf('Win') > -1)
    	window.chrome.webview.postMessage(message);
	else
		Cocoa.send(message);
}

function CODE(text){ SEND("CODE " + text); }
function MIDI(text){ SEND("MIDI " + text); }
function RUN(text){ SEND("RUN " + text); }
function SET(text, value){ SEND("SET " + text + " " + value); }
function FOCUS() { SEND("FOCUS"); }
